#version 300 es

precision highp float;

uniform float uTime;

in vec4 color;
in vec3 mpos;
in vec3 wpos;
in vec3 mnormal;

out vec4 outColor;

float heightFactor = 0.0;
float timeScale = 0.5;
vec4 fxColor = vec4(0,1,1,1);

float lines(float p)
{
	float density = 40.0;
	float stepScale = clamp(heightFactor * 5.0, 0.0, 0.3);
	stepScale = max(stepScale, heightFactor * 8.0);
	return step(stepScale, 1.0 - abs(sin(p * density)));
}

float grid(vec2 coords)
{
	float a = lines(coords.y * 2.0);
	float b = lines(coords.x - coords.y);
	float c = lines(coords.x + coords.y);
	return 1.0 - max(a, max(b, c));
}

void main() {

	heightFactor = clamp(-0.005 / (sin(uTime * timeScale) - wpos.y), 0.0, 1.0);
	
	vec3 animMpos = mpos;
	animMpos.y += uTime * 0.2 * sign(cos(uTime * timeScale));
	float gridZY = grid(animMpos.zy);
	float gridXZ = grid(animMpos.xz);
	float gridXY = grid(animMpos.xy);
	
	vec3 w = abs(mnormal);
	w = w / (w.x + w.y + w.z);
	
	float triplanarGrid = gridZY * w.x + gridXZ * w.y + gridXY * w.z;
	
	outColor = vec4(triplanarGrid) * fxColor * (1.2 - abs(mnormal.y)) * 0.25;
    outColor += heightFactor * 2.0 - 0.15;
   	outColor.a = min(fxColor.a, heightFactor * 10.0);   

   	outColor = clamp(outColor, 0.0, 1.0);
}