#include <complex>

[[using spirv: out, location(0)]]
vec4 outColor;

[[using spirv: uniform, location(0)]]
float scale;

[[using spirv: uniform, location(1)]]
int iter;

[[using spirv: uniform, location(2)]]
vec2 center;

[[using spirv: uniform, location(3)]]
vec2 resolution;

[[using spirv: uniform, binding(0)]]
sampler2D colormap;

[[spirv::frag]]
void frag_main() {
	vec2 uv = glfrag_FragCoord.xy / resolution;
	
	std::complex<float> c(1.3333f * (uv.x - 0.5) * scale - center.x, (uv.y - 0.5) * scale - center.y);
	std::complex<float> z = c;
	
	int i = 0;
	for (; i < iter; i++) {
		float x = (z.real() * z.real() - z.imag() * z.imag()) + c.real();
		float y = (z.imag() * z.real() + z.real() * z.imag()) + c.imag();
        
        z = std::complex<float>(x,y);

        if (std::abs(z) > 2.0)
            break;
    }
    
	outColor = texture(colormap, vec2((i == iter ? 0.0 : i) / 100.0f, 0.0f));
}