#![cfg_attr(target_arch = "spirv", no_std)]
#![feature(lang_items)]
#![feature(register_attr)]
#![register_attr(spirv)]

use spirv_std::glam::{Vec2, Vec4};
use spirv_std::storage_class::{Input, Output};

#[allow(unused_attributes)]
#[spirv(vertex)]
pub fn main_vs(
	in_pos: Input<Vec2>,
    #[spirv(position)] mut out_pos : Output<Vec4>
) {
    out_pos.store(in_pos.load().extend(0.0).extend(1.0));
}
